#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../common/cancel_appointment'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/booked_appointment_detail'
require_relative '../../helper/modal'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../helper/error_validation'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/feedback'
require_relative '../../pages/landing_notifications'


describe '[Story# VAR-2828: Primary Care Direct Appointment - Disable Selection]' do

  include DriverUtility
  include OracleUtility
  include DateUtility
  include MongoUtility


  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    @detail = BookedAppointmentDetail.new(@driver)
    @error = Error_Validation.new(@driver)
    @feedback = Feedback.new(@driver)
    @landing_notifications = LandingNotifications.new(@driver)
    TITLE = "Appointments/Requests"

    #mongo
    @db = connectToMongoDB("var-utility")
    restoreCollection("siteSupportingVAR", "var-utility", "sites-supporting-var-exported2.json", @db)
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    restoreCollection("directBookingEligibilityCriteria", "var-utility", "directSchedulingEnabled.json", @db)
    restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
    restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name.json", @db)
    @common.loginEndsOnHome(MockUser03)
    @common.selectAddAppointmentButton("VA")


  end

  after(:all) do
    @driver.close
  end


  context "AC# VAR-3112|TC# VAR-3174: Primary Care Direct Appointment Cancellation - criteria" do
    it "Patient without PACT team, disable the direct appointment radio button" do
      @common.waitWhileSpinnerPresent()
      @new_appointment.selectTypeOfCare(PRIMARY_CARE)
      @new_appointment.selectState("523")
      @new_appointment.selectLocation("523")
      @common.waitWhileSpinnerPresent()
      @new_appointment.scheduling_method_radio_elements[0].when_visible(TIME_OUT_LIMIT)
      expect(@new_appointment.scheduling_method_radio_elements[0].enabled?).to eq(false)

      expect(@new_appointment.direct_appoitnment_no_pact_team_error).to eq("You must have an assigned PACT team to directly schedule appointments. Please contact your facility for assistance.")

    end
  end
end








